/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.handlers;

import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Content {
    public static BufferedImage GreyedTile = Content.enlarge(Content.load("/Sprites/Tiles/SlantTileGreyed.png", 20, 20, 0, 0), 2);
    public static BufferedImage NormalTile = Content.enlarge(Content.load("/Sprites/Tiles/SlantTile.png", 20, 20, 0, 0), 2);
    public static BufferedImage LockTile = Content.enlarge(Content.load("/Sprites/Tiles/LockTile.png", 20, 20, 0, 0), 2);
    public static BufferedImage Sapphire = Content.enlarge(Content.load("/Sprites/Gems/Sapphire.png", 16, 16, 0, 0), 2);
    public static BufferedImage Amber = Content.enlarge(Content.load("/Sprites/Gems/Amber.png", 16, 16, 0, 0), 2);
    public static BufferedImage Amethyst = Content.enlarge(Content.load("/Sprites/Gems/Amethyst.png", 16, 16, 0, 0), 2);
    public static BufferedImage Diamond = Content.enlarge(Content.load("/Sprites/Gems/Diamond.png", 16, 16, 0, 0), 2);
    public static BufferedImage Emerald = Content.enlarge(Content.load("/Sprites/Gems/Emerald.png", 16, 16, 0, 0), 2);
    public static BufferedImage Ruby = Content.enlarge(Content.load("/Sprites/Gems/Ruby.png", 16, 16, 0, 0), 2);
    public static BufferedImage Bomb = Content.enlarge(Content.load("/Sprites/Abilities/Bomb.png", 20, 20, 0, 0), 2);
    public static BufferedImage Hammer = Content.enlarge(Content.load("/Sprites/Abilities/Hammer.png", 20, 20, 0, 0), 2);
    public static BufferedImage CrossArrows = Content.enlarge(Content.load("/Sprites/Abilities/Cross Arrows.png", 20, 20, 0, 0), 2);
    public static BufferedImage[] GemExplosion = Content.load("/Sprites/Gems/GemExplosion.png", 30, 40, 6);
    public static BufferedImage BlueSky = Content.enlarge(Content.load("/Backgrounds/Blue Sky.png", 320, 240, 0, 0), 2);
    public static BufferedImage TopBarHUD = Content.load("/HUD/Top Bar HUD.png", 640, 80, 0, 0);
    public static BufferedImage Mouse = Content.load("/HUD/Mouse.png", 20, 20, 0, 0);
    public static BufferedImage TokenB = Content.enlarge(Content.load("/HUD/Token.png", 20, 20, 0, 0), 2);
    public static BufferedImage TokenS = Content.load("/HUD/Token.png", 20, 20, 0, 0);
    public static BufferedImage[] PowerBox = Content.load("/HUD/Power Box.png", 60, 60, 2, 2.0);
    public static BufferedImage[] Star = Content.load("/HUD/Star.png", 40, 40, 2, 2.0);
    public static BufferedImage[] StarFill = Content.load("/HUD/Star Fill Bar.png", 140, 8, 67, 2.0);
    public static BufferedImage PowerMenu = Content.enlarge(Content.load("/HUD/Power Menu.png", 120, 120, 0, 0), 2);
    public static BufferedImage RewindTime = Content.enlarge(Content.load("/HUD/Rewind Time.png", 20, 20, 0, 0), 2);
    public static BufferedImage[] CircleMenuButton = Content.load("/HUD/Circle Menu Button.png", 60, 40, 2, 2.0);
    public static BufferedImage[] CirclePauseButton = Content.load("/HUD/Circle Pause Button.png", 60, 40, 2, 2.0);
    public static BufferedImage[] CircleResetButton = Content.load("/HUD/Circle Reset Button.png", 60, 40, 2, 2.0);

    public static BufferedImage[][] load(String s, int w, int h) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[][] ret = new BufferedImage[height][width];
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[i][j] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage[][] load(BufferedImage spritesheet, int w, int h) {
        try {
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[][] ret = new BufferedImage[height][width];
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[i][j] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage[] load(String s, int w, int h, int numFrames) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[] ret = new BufferedImage[numFrames];
            int k = 0;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[k] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++k;
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage[] load(String s, int w, int h, int numFrames, double scale) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            spritesheet = Content.enlarge(spritesheet, (int)scale);
            int width = spritesheet.getWidth() / w;
            int height = spritesheet.getHeight() / h;
            BufferedImage[] ret = new BufferedImage[numFrames];
            int k = 0;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    ret[k] = spritesheet.getSubimage(j * w, i * h, w, h);
                    ++k;
                    ++j;
                }
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage load(String s, int w, int h, int x, int y) {
        try {
            BufferedImage spritesheet = ImageIO.read(Content.class.getResourceAsStream(s));
            BufferedImage ret = spritesheet.getSubimage(x, y, w, h);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error loading graphics.");
            return null;
        }
    }

    public static BufferedImage enlarge(BufferedImage image, int n) {
        int w = n * image.getWidth();
        int h = n * image.getHeight();
        BufferedImage enlargedImage = new BufferedImage(w, h, image.getType());
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                enlargedImage.setRGB(x, y, image.getRGB(x / n, y / n));
                ++x;
            }
            ++y;
        }
        return enlargedImage;
    }
}

